/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here. For example:
	// config.language = 'fr';
	// config.uiColor = '#AADC6E';
	config.extraPlugins = 'uploadimage';
	config.uploadUrl = '/uploader/upload.php';
};




// Create a classic editor using inline configuration
var uploadUrl = '/ckfinder/core/connector/php/connector.php?command=QuickUpload';

var config = {
    customConfig : '',
    // Add the required plugin
    extraPlugins : 'simpleuploads',
    // Required config to tell CKEditor what's the script that will process uploads
    filebrowserUploadUrl : uploadUrl + '&type=Files',
    filebrowserImageUploadUrl : uploadUrl + '&type=Images',
    toolbar :	// Sample toolbar
    [
        { name: 'document',    items : [ 'Source' ] },
        { name: 'clipboard',   items : [ 'Cut','Copy','Paste','-','Undo','Redo' ] },
        { name: 'basicstyles', items : [ 'Bold','Italic' ] },
        { name: 'insert',      items : [ 'Link', 'Image', 'addFile', 'addImage' ] },
        { name: 'tools',       items : [ 'Maximize' ] }
    ],

    // Define the file extensions (whitelist) that are allowed to upload.
    // This is a client side check. You must do the same validation on your server.
    // By default CKEditor doesn't implement this kind of check, so users can waste time and bandwith uploading files only to get an error message later
    // So setting this correctly can help your users greatly
    simpleuploads_acceptedExtensions : '7z|avi|csv|doc|docx|flv|gif|gz|gzip|jpeg|jpg|mov|mp3|mp4|mpc|mpeg|mpg|ods|odt|pdf|png|ppt|pxd|rar|rtf|tar|tgz|txt|vsd|wav|wma|wmv|xls|xml|zip'
};

CKEDITOR.replace( 'editor1', config );
CKEDITOR.editorConfig = function (config) {

    /* Custom plugins */
    config.plugins += ',codemirror,youtube,templates';

    ...