<?php 
error_reporting(0);
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//session_start(); //we need to call PHP's session object to access it through CI

class Home extends CI_Controller 
{
    function __construct()
    {      
        parent::__construct();
 
       $this->load->model("homeDetails");
       $this->load->library("pagination");
        $this->load->helper('url'); //You should autoload this one ;)
        $this->load->helper('ckeditor');

        //Ckeditor's configuration
        $this->ckeditor_config = array(
            'toolbar'   =>  "MyToolbar",     //Using the Full toolbar
            'width'     =>  "100%",    //Setting a custom width
            'height'    =>  '100px',    //Setting a custom height
        );

        $this->ckeditor_styles = array(
            
            //Creating a new style named "style 1"
            'style 1' => array (
                'name'      =>  'Blue Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'     =>  'Blue',
                    'font-weight'   =>  'bold'
                )
            ),
            
            //Creating a new style named "style 2"
            'style 2' => array (
                'name'  =>  'Red Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'         =>  'Red',
                    'font-weight'       =>  'bold',
                    'text-decoration'   =>  'underline'
                )
            )               
        );
    }

    function index()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            $this->load->view('CMS/home/index',$data);
       }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }

    function logout()
    {
        $this->session->unset_userdata('logged_in');
        session_destroy();
        redirect('CMS/home', 'refresh');
    }
	
	function slider_add()
	{
			
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];    
        }

        $data['msg'] = "File Uploaded";
        $data['upload_data'] = '';

        //Ckeditor's configuration
        
        if(isset($_POST['slider_number']) || isset($_POST['slide_content'])) 
        {
            $number = $_POST['slider_number'];
            $content = $_POST['slide_content'];
            $image_filename ='';

            //Configure
            $config['upload_path'] = 'themes/images/slider';
            $config['max_size'] = '30240';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadBtn')) {
                $data['msg'] = $this->upload->display_errors();
            //echo $this->upload->display_errors();
			} 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name']; 
//echo "upload";				
            }

            $dataArray=array('slider_number'=>$number,'image'=>$image_filename,'content'=>$content);
            $LastInsertedId = $this->homeDetails->addSlider($dataArray);

            if($LastInsertedId)
            {
                $data['msg']='Inserted Slider';   
                $data['slider'] = $this->homeDetails->getSliderFromId($LastInsertedId);
                $this->load->view('CMS/home/slider_view',$data);                
            }
            else
            {
				$data['slider']="";
                $data['msg']='No Slider To Display !!!...';       
                $this->load->view('CMS/home/slider_view',$data);
            }
        }
        else
        {
            //$data['team_designation'] = $this->homeDetails->getAll();
            $this->load->view('CMS/home/slider_add');
        }
			
			
			
	}
	function slider_update()
	{
		
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];    

        if(isset($_POST['slide_number']) || isset($_POST['slide_content'])) 
        {
            if ($_FILES["uploadBtn"]["error"]> 0)
            {
                $image_filename = $_POST['previous_image'];//set old image file
            }
            else
            {
                unlink(FCPATH.'themes/images/slider/'.$_POST['previous_image']);   //delete old image file                
            }
            $number = $_POST['slide_number'];
            $content = $_POST['slide_content'];
            $id = $_POST['id'];

            //Configure
            //set the path where the files uploaded will be copied. NOTE if using linux, set the folder to permission 777
            $config['upload_path'] = 'themes/images/slider/';
            $config['max_size'] = '30240';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadBtn')) {
                $data['msg'] = $this->upload->display_errors();

            } 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name'];                
            }

            $dataArray=array('slider_number'=>$number,'image'=>$image_filename,'content'=>$content);
            $updated = $this->homeDetails->updateSlider($id, $dataArray);

            if($updated==1)
            {
                $data['msg']='Updated Record';   
            }
            else
            {
                $data['msg']='No leaders To Update !!!...';       
            }

            $data['slider'] = $this->homeDetails->getSliderFromId($id);
            $this->load->view('CMS/home/slider_view',$data);
        }
        else
        {
            $data['msg']='No Slider To Update !!!...';       
            $data['slider'] = $this->homeDetails->getAllSlider();
            //$data['team_designation'] = $this->team_designation->getAll();
            $this->load->view('CMS/home/slider_update',$data);            
        }
	}
	function slider_details_json($id)
	{
		$size = count($this->homeDetails->getSliderFromId($id));
        $dataArr = $this->homeDetails->getSliderFromId($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
		
	}
	
	function slider_delete()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];    
        }

        if(isset($_POST['slideToDelete'])) 
        {
            foreach($_POST['slideToDelete'] as $team)
            {
				$team1=$this->homeDetails->getSliderFromId($team);
				foreach($team1 as $t)
				{
					//echo $t->image;
				unlink(FCPATH.'themes/images/slider/'.$t->image);
				}
                //delete record
                $deleted = $this->homeDetails->deleteSlider($team);
			  // echo $team;
            }

            if($deleted==1)
            {
                $data['msg']='Deleted Record';   
            }
            else
            {
                $data['msg']='No slider To Delete !!!...';       
            }
            //clear POST data
            $_POST = array();

            //get team updated data from ID
            $data['slider'] = $this->homeDetails->getAllSlider();
            $this->load->view('CMS/home/slider_view',$data);
        }
        else
        {
            $data['msg']='No slider To Delete !!!...';   
            $data['slider'] = $this->homeDetails->getAllSlider();
            $this->load->view('CMS/home/slider_delete',$data);   
        }
	}
	function slider_view()
	{
		$session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No Slider To Display !!!...';       
        $data['slider'] = $this->homeDetails->getAllSlider();
        
        $this->load->view('CMS/home/slider_view', $data);
	}
    function sellerlist()
    {
        // echo "hi";
        if($this->session->userdata('logged_in'))
        {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No Seller To Display !!!...';       
        $data['seller_list'] = $this->homeDetails->getallsellers();
        $this->load->view('CMS/home/sellerlists', $data);
        }
        else
        {
            redirect('CMS/login','refresh');
        }
    }

    function special_offer_add()
    {

        if($this->session->userdata('logged_in'))
        {
            if($this->session->userdata('logged_in'))
            {
                $session_data = $this->session->userdata('logged_in');
                $data['username'] = $session_data['username'];    
            }


            //Ckeditor's configuration
            
            if(isset($_POST['content'])) 
            {

                $content = $_POST['content'];
               
                $dataArray=array('content'=>$content);
                
                $LastInsertedId = $this->homeDetails->addSpecialoffer($dataArray);

                if($LastInsertedId)
                {
                    $data['msg']='Inserted Special Offer';   
                    $data['specialoffer'] = $this->homeDetails->getSpecialofferFromId($LastInsertedId);
                    $this->load->view('CMS/home/special_offer_view',$data);                
                }
                else
                {
                    $data['specialoffer']="";
                    $data['msg']='No Special Offer To Display !!!...';       
                    $this->load->view('CMS/home/special_offer_view',$data);
                }
            }
            else
            {
                //$data['team_designation'] = $this->homeDetails->getAll();
                $this->load->view('CMS/home/special_offer_add');
            }
        }
        else
        {
            redirect('CMS/login');
        }
    }

    function special_offer_view()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];

            $config = array();
 
           $config["base_url"] = base_url()."CMS/home/special_offer_view";
            //print_r($config["base_url"]);die;
           $config["total_rows"] = $this->homeDetails->record_count2();
            
           $config["per_page"] = 10;
     
           $config["uri_segment"] = 4;
            
           $this->pagination->initialize($config);
     
           $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
           $data["specialoffer"] = $this->homeDetails->special_offer($config["per_page"], $page);
           
            $data['msg']='No Special Offer To Display !!!...';       
           
           $data["links"] = $this->pagination->create_links();
            
            $this->load->view('CMS/home/special_offer_view', $data);
        }
        else
        {
            redirect('CMS/login');
        }
    }

    function special_offer_update()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];    
            
            //Ckeditor's configuration
            $data['ckeditor_details_update'] = array(
            
                //ID of the textarea that will be replaced
                'id'    =>  'details',
                'path'  =>  'scripts/ckeditor',
            
                //Optionnal values
                'config' => $this->ckeditor_config,
            
                //Replacing styles from the "Styles tool"
                'styles' => $this->ckeditor_styles
            );

            if(isset($_POST['content']))
            {
                

                $content = $_POST['content'];
                $id = $_POST['id'];

                

                $dataArray=array('content'=>$content);

                $updated = $this->homeDetails->update_special_offer($id, $dataArray);

                if($updated==1)
                {
                    $data['msg']='Updated Record';   
                }
                else
                {
                    $data['msg']='No Special Offer To Update !!!...';       
                }

                $data['specialoffer'] = $this->homeDetails->getSpecialofferFromId($id);
                $this->load->view('CMS/home/special_offer_view',$data);
            }
            else
            {
                $data['msg']='No leaders To Update !!!...';       
                $data['specialoffer'] = $this->homeDetails->getspecialofferAll();
                //$data['team_designation'] = $this->team_designation->getAll();
                $this->load->view('CMS/home/special_offer_update',$data);            
            }
        }
        else
        {
            redirect('CMS/login');
        }
    }
    
    function specialoffer_details_json($id)
    {
        
        $size = count($this->homeDetails->getSpecialofferFromId($id));
        $dataArr = $this->homeDetails->getSpecialofferFromId($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
        
        
    }

    function special_offer_Delete()
    {
        if($this->session->userdata('logged_in'))
        {
            if($this->session->userdata('logged_in'))
            {
                $session_data = $this->session->userdata('logged_in');
                $data['username'] = $session_data['username'];    
            }

            if(isset($_POST['rtToDelete'])) 
            {
                foreach($_POST['rtToDelete'] as $rt)
                {
                    //delete record
                    $deleted = $this->homeDetails->deletespecialoffer($rt);
                   //echo $rt;
                }

                if($deleted==1)
                {
                    $data['msg']='Deleted Record';   
                }
                else
                {
                    $data['msg']='No Rotatng Text To Delete !!!...';       
                }
                //clear POST data
                $_POST = array();

                //get special_offer updated data from ID
                $data['specialoffer'] = $this->homeDetails->getspecialofferAll();
                $this->load->view('CMS/home/special_offer_view',$data);
            }
            else
            {
                $data['msg']='No Team To Delete !!!...';   
                $data['specialoffer'] = $this->homeDetails->getspecialofferAll();
                $this->load->view('CMS/home/special_offer_delete',$data);   
            }
        }
        else
        {
            redirect('CMS/login');
        }
    }

    function customerlist()
    {
        // echo "hi";
        if($this->session->userdata('logged_in'))
        {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No Customer To Display !!!...';       
        $data['customer_list'] = $this->homeDetails->getallcustomers();
        $this->load->view('CMS/home/customerlists', $data);
        }
        else
        {
            redirect('CMS/login','refresh');
        }
    }
    
    function reportlist()
    {
        // echo "hi";
        if($this->session->userdata('logged_in'))
        {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No Orders To Display !!!...';    
        $sql = "
            SELECT 
                o.product_id, 
                o.order_date,
                o.product_name,
                o.image,
                count(o.product_id) as total_orders_by_product,
                sum(o.qty) as total_qty

                FROM `order` as o group by o.product_id
        ";   
        $data['orderlist_by_product']  = $this->homeDetails->raw_query($sql);

        $this->load->view('CMS/home/reportlist', $data);
        }
        else
        {
            redirect('CMS/login','refresh');
        }
    }
    
    function reportlist_with_filters() {
        // echo "hi";
       
        
        if($this->session->userdata('logged_in'))
        {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No Orders To Display !!!...'; 
        
        
        if($this->input->get()){
            $form_data = $this->input->get();
            
            $fromdate = date('d-m-Y', strtotime($form_data['from-date']));
            $todate = date('d-m-Y', strtotime($form_data['to-date']));
            $category = $form_data['category'];
            $sub_category = $form_data['sub_category'];
            $category_name = '';
            // $sub_category = '';
            if($category !='' && $sub_category == ''){
                
                $cat_sql = "SELECT * FROM `product_category` WHERE id = " . $category;
                $caregory_details = $this->homeDetails->raw_query($cat_sql);
                $category_name = $caregory_details[0]['category_name'];
                $sql = "
                    SELECT 
                        o.product_id, 
                        o.order_date, 
                        o.product_name, 
                        p.category, 
                        p.sub_category, 
                        o.image, 
                        count(o.product_id) as total_orders_by_product, 
                        sum(o.qty) as total_qty
        
                        FROM `order` as o 
                        INNER JOIN product as p ON o.product_id = p.id 
                        where o.order_date BETWEEN '". $fromdate ."' AND '". $todate ."' AND p.category = '". $category_name ."' group by o.product_id
                    ";
            } else if ($category !='' && $sub_category !=''){
                
                $cat_sql = "SELECT * FROM `product_category` WHERE id = " . $category;
                $caregory_details = $this->homeDetails->raw_query($cat_sql);
                $category_name = $caregory_details[0]['category_name'];
                
                $sql = "
                    SELECT 
                        o.product_id, 
                        o.order_date, 
                        o.product_name, 
                        p.category, 
                        p.sub_category, 
                        o.image, 
                        count(o.product_id) as total_orders_by_product, 
                        sum(o.qty) as total_qty
        
                        FROM `order` as o 
                        INNER JOIN product as p ON o.product_id = p.id 
                        where o.order_date BETWEEN '". $fromdate ."' AND '". $todate ."' AND p.category = '". $category_name ."' AND p.sub_category = '". $sub_category ."' group by o.product_id
                    ";
            } else {
                $sql = "
                        SELECT 
                            o.product_id, 
                            o.order_date, 
                            o.product_name, 
                            p.category, 
                            p.sub_category, 
                            o.image, 
                            count(o.product_id) as total_orders_by_product, 
                            sum(o.qty) as total_qty
            
                            FROM `order` as o INNER JOIN product as p ON o.product_id = p.id 
                            where o.order_date BETWEEN '". $fromdate ."' AND '". $todate ."' group by o.product_id
                        ";    
            }
            // echo $sql;
        } else {
        
            $today = date("d-m-Y");  
            $sql = "
            SELECT 
                o.product_id, 
                o.order_date, 
                o.product_name, 
                p.category, 
                p.sub_category, 
                o.image, 
                count(o.product_id) as total_orders_by_product, 
                sum(o.qty) as total_qty

                FROM `order` as o INNER JOIN product as p ON o.product_id = p.id 
                where o.order_date = '". $today ."' group by o.product_id
            ";   
        }
        
        $categories_sql = "SELECT * FROM `product_category`";
        if(!empty($category)) {
            $sub_categories_sql = "SELECT * FROM product_sub_category Where category_id = " . $category;
            
        } else {
            $sub_categories_sql = "SELECT * FROM product_sub_category";
        }
        // echo $sql;
        $data['orderlist_by_product']  = $this->homeDetails->raw_query($sql);
        $data['categories']  = $this->homeDetails->raw_query($categories_sql);
        $data['sub_categories']  = $this->homeDetails->raw_query($sub_categories_sql);
        $data['fromdate'] = isset($fromdate) ? date('Y-m-d', strtotime($fromdate)) : date('Y-m-d');
        $data['todate'] = isset($todate) ? date('Y-m-d', strtotime($todate)) : date('Y-m-d');
        $data['selected_category'] = isset($category_name) ? $category_name : '';
        $data['selected_sub_category'] = isset($sub_category) ? $sub_category : '';
// echo "<pre>"; print_r($data); echo "</pre>";
        $this->load->view('CMS/home/reportlist_filters', $data);
        }
        else
        {
            redirect('CMS/login','refresh');
        }
    }
    
    function getSubCategories() {
        $category = $this->input->get('category');
      // Replace this with your own code to retrieve categories from your database
      // Prepare and execute the SQL query to retrieve categories
      if(!empty($category)){
        $sql = "SELECT * FROM product_sub_category WHERE category_id = ".$category;    
      } else {
          $sql = "SELECT * FROM product_sub_category";
      }
      
      $subcategories = $this->homeDetails->raw_query($sql);
   
    //   echo "<pre>"; print_r($subcategories); echo "</pre>";
      echo json_encode($subcategories);
    }


    
}

?>