<?php 
error_reporting(0);
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//session_start(); //we need to call PHP's session object to access it through CI
class Product extends CI_Controller 
{
    function __construct()
    {
        parent::__construct();
        $this->load->helper("url");
 
       $this->load->model("product_details");
 
       $this->load->library("pagination");
         //Ckeditor's configuration
        $this->ckeditor_config = array(
            'toolbar'   =>  'MyToolbar',     //Using the Full toolbar
            'width'     =>  '100%',    //Setting a custom width
            'height'    =>  '100px'    //Setting a custom height
        );

        $this->ckeditor_styles = array(
            
            //Creating a new style named "style 1"
            'style 1' => array (
                'name'      =>  'Blue Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'     =>  'Blue',
                    'font-weight'   =>  'bold'
                )
            ),
            
            //Creating a new style named "style 2"
            'style 2' => array (
                'name'  =>  'Red Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'         =>  'Red',
                    'font-weight'       =>  'bold',
                    'text-decoration'   =>  'underline'
                )
            )               
        );
    }

    function index()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            $this->load->view('CMS/product/index',$data);
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }
    //leaders Functions
	
	function category_add()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];



			if(isset($_POST['category_name']))
			{
				$name=$_POST['category_name'];
                $image_filename ='';

            //Configure
            $config['upload_path'] = 'themes/images/products/';
            //$config['max_size'] = '30240';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png|pdf';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadFile')) {
                $data['msg'] = $this->upload->display_errors();
            //echo $this->upload->display_errors();
            } 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name']; 
//echo "upload";                
            }


				$data=array('category_name'=>$name,'image'=>$image_filename);
				$add=$this->Product_details->addcategory($data);
				if($add)
				{	
					$data['msg']="category add";
					$data['category']=$this->Product_details->getCategoryById($add);
					$this->load->view('CMS/product/sub_category_view',$data);
				}else
				{
					$this->load->view('CMS/product/category_add',$data);
				}
			}else
			{
            $this->load->view('CMS/product/category_add',$data);
			}
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
		
	}
	
	function category_Update()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			if(isset($_POST['category_name']))
			{
                if ($_FILES["uploadBtn"]["error"]> 0)
                {
                    $image_filename = $_POST['previous_image'];//set old image file
                }
                else
                {
                    unlink(FCPATH.'themes/images/products/'.$_POST['previous_image']);   //delete old image file                
                }
				$id=$_POST['categoryDDL'];
				$name=$_POST['category_name'];

                //Configure
            //set the path where the files uploaded will be copied. NOTE if using linux, set the folder to permission 777
            $config['upload_path'] = 'themes/images/products/';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadBtn')) {
                $data['msg'] = $this->upload->display_errors();

            } 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name'];                
            }




				$data=array('category_name'=>$name,'image'=>$image_filename);
                //print_r($data);
                //die;
				$add=$this->Product_details->updateCategory($id,$data);
				if($add)
				{	
					$data['msg']="category Update";
					$data['category']=$this->Product_details->getCategoryById($id);
					$this->load->view('CMS/product/category_view',$data);
				}else
				{
					$data['category']=$this->Product_details->getAllCategory1();
					$this->load->view('CMS/product/category_update',$data);
				}
			}else
			{
            $data['category']=$this->Product_details->getAllCategory1();
			$this->load->view('CMS/product/category_update',$data);
			}
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
	}
	function category_details_json($id)
    {
        $size = count($this->Product_details->getCategoryById($id));
        $dataArr = $this->Product_details->getCategoryById($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
		
		
		
	}
		
	function category_delete()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			if(isset($_POST['categoryToDelete']))
			{
				foreach($_POST['categoryToDelete'] as $c)
				{
					$this->Product_details->deleteCategory($c);
				}
				
			$data['msg']="NO Category To Display";
			$data['category']=$this->Product_details->getAllCategory();
			$this->load->view('CMS/product/category_view',$data);
			
			}else{
			$data['msg']="NO Category To Delete";
			$data['category']=$this->Product_details->getAllCategory1();
			$this->load->view('CMS/product/category_delete',$data);
			}
		}
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
	}
	
	function category_View()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			
			$data['msg']="NO Category To Display";
			$data['category']=$this->Product_details->getAllCategory();
			$this->load->view('CMS/product/category_view',$data);
		}
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
	}
	
	function subcategory_add()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			if(isset($_POST['category_name']))
			{
				$id=$_POST['categoryDDL'];
				$name=$_POST['Sub_category_name'];	

				$data=array('category_id'=>$id,'subcategory_name'=>$name);
				$add=$this->Product_details->addSubCategory($data);
				if($add)
				{	
					$data['msg']="Sub-category add";
					$data['subcategory']=$this->Product_details->getSubCategoryById($add);
					$this->load->view('CMS/product/sub_category_view',$data);
				}else
				{
					$data['category']=$this->Product_details->getAllCategory();
					$this->load->view('CMS/product/sub_category_add',$data);
				}
			}else
			{
           
		   $data['category']=$this->Product_details->getAllCategory1();
			$this->load->view('CMS/product/sub_category_add',$data);
			}
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
		
	}
	
	function subcategory_update()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			if(isset($_POST['Sub_category_name']))
			{
				$id=$_POST['subCategoryDDL'];
				$name=$_POST['Sub_category_name'];	

				$data=array('subcategory_name'=>$name);
				$add=$this->Product_details->updateSubCategory($id,$data);
				if($add)
				{	
					$data['msg']="Sub-category Update";
					$data['subcategory']=$this->Product_details->getSubCategoryById($id);
					$this->load->view('CMS/product/sub_category_view',$data);
				}else
				{
					$data['category']=$this->Product_details->getAllCategory();
					$this->load->view('CMS/product/sub_category_update',$data);
				}
			}else
			{
           
		   $data['category']=$this->Product_details->getAllCategory1();
			$this->load->view('CMS/product/sub_category_update',$data);
			}
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
		
	
	}
	
	function subcategory_details_json($id)
    {
        $size = count($this->Product_details->getOnlySubCategoryById($id));
        $dataArr = $this->Product_details->getOnlySubCategoryById($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
		
		
		
	} 
	
	function subcategoryname_details_json($id)
    {
        $size = count($this->Product_details->getSubCategoryNameById($id));
        $dataArr = $this->Product_details->getSubCategoryNameById($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
		
		
		
	}
	
	function subcategory_delete()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			if(isset($_POST['subcatToDelete']))
			{
				foreach($_POST['subcatToDelete'] as $s)
				{
					$this->Product_details->deleteSubCategory($s);
					//echo $s;
				}
				
				$data['msg']="Sub-category Deleted";
			$data['subcategory']=$this->Product_details->getAllSubCategory();
			$this->load->view('CMS/product/sub_category_view',$data);
			
			}else{
			$data['msg']="NO Sub-category To Delete";
			$data['subcategory']=$this->Product_details->getAllSubCategory1();
			$this->load->view('CMS/product/sub_category_delete',$data);
			}
		}
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
	}
	
	function subcategory_view()
	{
		if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
			
			$data['msg']="NO Sub-category To Display";
			$data['subcategory']=$this->Product_details->getAllSubCategory();
			$this->load->view('CMS/product/sub_category_view',$data);
		}
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
	}
    function product_Add()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];    
        }

        $data['msg'] = "File Uploaded";
        $data['upload_data'] = '';

        //Ckeditor's configuration
        $data['ckeditor_details_add'] = array(
        
            //ID of the textarea that will be replaced
            'id'    =>  'details',
            'path'  =>  'scripts/ckeditor',
        
            //Optionnal values
            'config' => $this->ckeditor_config,
        
            //Replacing styles from the "Styles tool"
            'styles' => $this->ckeditor_styles
        );

        if(isset($_POST['product_name']) || isset($_POST['details'])) 
        {
            $category_name = $_POST['category_name'];
            $Sub_category_name = $_POST['Sub_category_name'];
            $name = $_POST['product_name'];
            $liter = $_POST['liter'];
            $price = $_POST['product_price'];
            $aprice = $_POST['product_aprice'];
            $qty = $_POST['product_qty'];
            $details = $_POST['details'];
            $image_filename ='';

            //Configure
            $config['upload_path'] = 'themes/images/products';
            //$config['max_size'] = '30240';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png|pdf';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadBtn')) {
                $data['msg'] = $this->upload->display_errors();
            //echo $this->upload->display_errors();
			} 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name']; 
//echo "upload";				
            }

           $dataArray=array('category'=>$category_name,'Sub_category'=>$Sub_category_name,'name'=>$name,'liter_quantity'=>$liter,'price'=>$price,'actual_price'=>$aprice,'quantity'=>$qty,'details'=>$details,'image'=>$image_filename);
            $LastInsertedId = $this->Product_details->add($dataArray);

			
			if(!empty($_FILES['uploadBtn1']['name'])){
            $filesCount = count($_FILES['uploadBtn1']['name']);
            for($i = 0; $i < $filesCount; $i++)
			{
                $_FILES['userFile']['name'] = $_FILES['uploadBtn1']['name'][$i];
                $_FILES['userFile']['type'] = $_FILES['uploadBtn1']['type'][$i];
                $_FILES['userFile']['tmp_name'] = $_FILES['uploadBtn1']['tmp_name'][$i];
                $_FILES['userFile']['error'] = $_FILES['uploadBtn1']['error'][$i];
                $_FILES['userFile']['size'] = $_FILES['uploadBtn1']['size'][$i];

                //$uploadPath = 'uploads/files/';
               /* $config['upload_path'] = 'themes/images/propertyImages/';
                $config['allowed_types'] = 'gif|jpg|png';
                
                $this->load->library('upload', $config);
                $this->upload->initialize($config);**/
                if($this->upload->do_upload('userFile')){
                    $fileData = $this->upload->data();
                    //$uploadData[$i]['image'] = $fileData['file_name'];
                    //$uploadData[$i]['product_id'] = $LastInsertedId;
                    //$uploadData[$i]['name'] = $name;
                    //$uploadData[$i]['modified'] = date("Y-m-d H:i:s");
                }
				$data=array('product_id'=>$LastInsertedId,'name'=>$name,'image'=>$_FILES['userFile']['name']);
				$this->Product_details->addImages($data);
            }	

            }
			
            if($LastInsertedId)
            {
                $data['msg']='Inserted Record';   
                $data['product_details'] = $this->Product_details->getFromId($LastInsertedId);
                $this->load->view('CMS/product/product_view',$data);                
            }
            else
            {
                $data['msg']='No Product Details To Display !!!...';       
                $this->load->view('CMS/product/product_view',$data);
            }
        }
        else
        {
            //$data['team_designation'] = $this->about_us->getAll();
            $data['category']=$this->Product_details->getAllCategory1();
			$this->load->view('CMS/product/product_add',$data);
        }
    }
    
    function product_Update()
    {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];    
        
        //Ckeditor's configuration
        $data['ckeditor_details_update'] = array(
        
            //ID of the textarea that will be replaced
            'id'    =>  'details',
            'path'  =>  'scripts/ckeditor',
        
            //Optionnal values
            'config' => $this->ckeditor_config,
        
            //Replacing styles from the "Styles tool"
            'styles' => $this->ckeditor_styles
        );

        if(isset($_POST['name']) || isset($_POST['details'])) 
        {
            if ($_FILES["uploadBtn"]["error"]> 0)
            {
                $image_filename = $_POST['previous_image'];//set old image file
            }
            else
            {
                unlink(FCPATH.'themes/images/products/'.$_POST['previous_image']);   //delete old image file                
            }

            $name = $_POST['name'];
            $category_name = $_POST['category_name'];
            $Sub_category_name = $_POST['Sub_category_name'];
            $price = $_POST['product_price'];
            $aprice = $_POST['product_aprice'];
            $qty = $_POST['product_qty'];
            $liter = $_POST['liter'];
            $details = $_POST['details'];
            $id = $_POST['id'];

            //Configure
            //set the path where the files uploaded will be copied. NOTE if using linux, set the folder to permission 777
            $config['upload_path'] = 'themes/images/products/';
            
            // set the filter image types
            $config['allowed_types'] = 'gif|jpg|png';
            
            //load the upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->set_allowed_types('*');
            $data['upload_data'] = '';
        
            //if not successful, set the error message
            if (!$this->upload->do_upload('uploadBtn')) {
                $data['msg'] = $this->upload->display_errors();

            } 
            else
            { //else, set the success message
                $data['msg'] = "Upload success!";
                $data['upload_data'] = $this->upload->data();
                $image_filename = $data['upload_data'] ['file_name'];                
            }

            $dataArray=array('category'=>$category_name,'sub_category'=>$Sub_category_name,'name'=>$name,'liter_quantity'=>$liter,'price'=>$price,'actual_price'=>$aprice,'quantity'=>$qty,'details'=>$details,'image'=>$image_filename);
            $updated = $this->Product_details->update($id, $dataArray);
				
				if(!empty($_FILES['uploadBtn1']['name'])){
            $filesCount = count($_FILES['uploadBtn1']['name']);
            for($i = 0; $i < $filesCount; $i++)
			{
                $_FILES['userFile']['name'] = $_FILES['uploadBtn1']['name'][$i];
                $_FILES['userFile']['type'] = $_FILES['uploadBtn1']['type'][$i];
                $_FILES['userFile']['tmp_name'] = $_FILES['uploadBtn1']['tmp_name'][$i];
                $_FILES['userFile']['error'] = $_FILES['uploadBtn1']['error'][$i];
                $_FILES['userFile']['size'] = $_FILES['uploadBtn1']['size'][$i];

                //$uploadPath = 'uploads/files/';
               /* $config['upload_path'] = 'themes/images/propertyImages/';
                $config['allowed_types'] = 'gif|jpg|png';
                
                $this->load->library('upload', $config);
                $this->upload->initialize($config);**/
                if($this->upload->do_upload('userFile')){
                    $fileData = $this->upload->data();
                    //$uploadData[$i]['image'] = $fileData['file_name'];
                    //$uploadData[$i]['product_id'] = $LastInsertedId;
                    //$uploadData[$i]['name'] = $name;
                    //$uploadData[$i]['modified'] = date("Y-m-d H:i:s");
                }
				$data=array('product_id'=>$id,'name'=>$name,'image'=>$_FILES['userFile']['name']);
				$this->Product_details->addImages($data);
            }	

            }
				
				
            if($updated==1)
            {
                $data['msg']='Updated Record';   
            }
            else
            {
                $data['msg']='No leaders To Update !!!...';       
            }

            $data['product_details'] = $this->Product_details->getFromId($id);
            $this->load->view('CMS/product/product_view',$data);
        }
        else
        {
            $data['msg']='No Product Details To Update !!!...';       
            $data['product_details'] = $this->Product_details->getAll1();
             $data['category']=$this->Product_details->getAllCategory1();
			//$data['team_designation'] = $this->team_designation->getAll();
            $this->load->view('CMS/product/product_update',$data);            
        }
    }
    
    function product_details_json($id)
    {
        //$data=$id;
		/*$d = array_shift($this->about_us->getTeamFromId($id));
		$data=$this->db->last_query($d);
        header('Content-Type: application/json');
        echo json_encode($data);*/
        //$this->load->view('Home/news_view',$data);
		
		
		$size = count($this->Product_details->getFromId($id));
        $dataArr = $this->Product_details->getFromId($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
		
		
    }

    function product_Delete()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];    
        }

        if(isset($_POST['teamToDelete'])) 
        {
            foreach($_POST['teamToDelete'] as $team)
            {
				$team1=$this->Product_details->getFromId($team);
				foreach($team1 as $t)
				{
					//echo $t->image;
					unlink(FCPATH.'themes/images/products/'.$t->image);
				}
                //delete record
                $deleted = $this->Product_details->delete($team);
			   //echo $team;
            }

            if($deleted==1)
            {
                $data['msg']='Deleted Record';   
            }
            else
            {
                $data['msg']='No Product Details To Delete !!!...';       
            }
            //clear POST data
            $_POST = array();

            //get team updated data from ID
            $data['product_details'] = $this->Product_details->getAll();
            $this->load->view('CMS/product/product_view',$data);
        }
        else
        {
            $data['msg']='No Product Details To Delete !!!...';   
            $data['product_details'] = $this->Product_details->getAll1();
            $this->load->view('CMS/product/product_delete',$data);   
        }
    }
    function product_View()
    {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        // $data['product_details'] = $this->Product_details->getAll();
        // $this->load->view('CMS/product/product_view', $data);
        $config = array();
 
       $config["base_url"] = base_url()."CMS/product/product_View";
 
       $config["total_rows"] = $this->product_details->record_count();
    
       $config["per_page"] = 10;
 
       $config["uri_segment"] = 4;
 
       $this->pagination->initialize($config);
 
       $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
 
       $data["product_details"] = $this->product_details->fetch_departments($config["per_page"], $page);
        $data['msg']='No product Details To Display !!!...';       
       
       $data["links"] = $this->pagination->create_links();
 
       $this->load->view('CMS/product/product_view', $data);
    }
	
	function product_realted_delete()
    {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];
			if(isset($_POST['imageToDelete']))
			{
				foreach($_POST['imageToDelete'] as $img)
				{
					//echo $img;
					$this->Product_details->deleteImages($img);
				}
				$data['msg']='No product Details To Display !!!...';       
        $data['product_images'] = $this->Product_details->getProductRelatedImagesAll();
        $this->load->view('CMS/product/product_related_images_View', $data);

			}else{
        $data['msg']='No product Details To Display !!!...';       
        $data['product_images'] = $this->Product_details->getProductRelatedImagesAll1();
        $this->load->view('CMS/product/product_related_images_delete', $data);
			}
    }
	
	
	function product_realted_View()
    {
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];

        $data['msg']='No product Details To Display !!!...';       
        $data['product_images'] = $this->Product_details->getProductRelatedImagesAll();
        $this->load->view('CMS/product/product_related_images_view', $data);
    }

}
?>