<?php 
error_reporting(0);
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//session_start(); //we need to call PHP's session object to access it through CI
class Testimonial_videos extends CI_Controller 
{
    function __construct()
    {
        parent::__construct();
        $this->load->helper('url'); //You should autoload this one ;)
        $this->load->model("Videos_details");
        $this->load->library("pagination");
        $this->load->helper('ckeditor');

         //Ckeditor's configuration
        $this->ckeditor_config = array(
            'toolbar'   =>  'MyToolbar',     //Using the Full toolbar
            'width'     =>  '100%',    //Setting a custom width
            'height'    =>  '100px'    //Setting a custom height
        );

        $this->ckeditor_styles = array(
            
            //Creating a new style named "style 1"
            'style 1' => array (
                'name'      =>  'Blue Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'     =>  'Blue',
                    'font-weight'   =>  'bold'
                )
            ),
            
            //Creating a new style named "style 2"
            'style 2' => array (
                'name'  =>  'Red Title',
                'element'   =>  'h2',
                'styles' => array(
                    'color'         =>  'Red',
                    'font-weight'       =>  'bold',
                    'text-decoration'   =>  'underline'
                )
            )               
        );
    }

    function index()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            $this->load->view('CMS/testimonial_videos/index',$data);
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }
    //leaders Functions
	
	function videos_add()
    {
        
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];



            if(isset($_POST['submit']))
            {
                     
                    $title=addslashes($_POST['title']);
                    $demo=addslashes($_POST['categoryDDL']);
        //             $image_filename ='';

        //             //Configure
        //             $config['upload_path'] = 'themes/images/videos/';

        //             $config['max_size'] = '9000000000';
                    
        //             // set the filter image types
        //             $config['allowed_types'] = 'mov|avi|flv|wmv|mp3|mp4';
                    
        //             //load the upload library
        //             $this->load->library('upload', $config);
        //             $this->upload->initialize($config);
        //             $this->upload->set_allowed_types('*');
        //             $data['upload_data'] = '';
                
        //             //if not successful, set the error message
        //             if (!$this->upload->do_upload('uploadFile')) 
        //             {
        //                 $data['msg'] = $this->upload->display_errors();
        //             //echo $this->upload->display_errors();
        //             } 
        //             else
        //             { //else, set the success message
        //                 $data['msg'] = "Upload success!";
        //                 $data['upload_data'] = $this->upload->data();
        //                 $image_filename = $data['upload_data'] ['file_name']; 
        // //echo "upload";                
        //             }
                       //$url='themes/images/videos/'.$image_filename;
                        $url= $_POST['uploadFile'];
                       
                        $data=array('section_id'=>$demo,'title'=>$title,'url'=>$url);
                        // print_r($data);
                        // die;
                        $add=$this->Videos_details->addvideos($data);
                        
                        if($add)
                        {   
                            $data['msg']="video add";
                            $data['videos']=$this->Videos_details->getVideosById($add);
                            $this->load->view('CMS/testimonial_videos/videos_view',$data);
                        }
                        else
                        {
                            $this->load->view('CMS/testimonial_videos/videos_add',$data);
                        }
            }
            else
            {
            $data['category']=$this->Videos_details->getallsections();
            $this->load->view('CMS/testimonial_videos/videos_add',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
        
    }

    function videos_update()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            if(isset($_POST['title']))
            {
                
                $id=$_POST['videosDDL'];
                $title=addslashes($_POST['title']);
                $videokey=addslashes($_POST['videokey']);
               
                 //$image_filename='themes/images/videos/'.$image_filename;

                $data=array('title'=>$title,'url'=>$videokey);
                //  print_r($data);
                // die;
                $add=$this->Videos_details->updateVideos($id,$data);
                if($add)
                {   
                    $data['msg']="Video Update";
                    $data['videos']=$this->Videos_details->getVideosById($id);
                    $this->load->view('CMS/testimonial_videos/videos_view',$data);
                }else
                {
                    $data['videos']=$this->Videos_details->getAllVideos();
                    $this->load->view('CMS/testimonial_videos/videos_update',$data);
                }
            }else
            {
            $data['videos']=$this->Videos_details->getAllVideos($config["per_page"], $page);
            $this->load->view('CMS/testimonial_videos/videos_update',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }
    
    function videos_details_json($id)
    {
        $size = count($this->Videos_details->getVideosById($id));
        $dataArr = $this->Videos_details->getVideosById($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data); 
    }

    function videos_delete()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            if(isset($_POST['videosToDelete']))
            {
                foreach($_POST['videosToDelete'] as $c)
                {
                    $this->Videos_details->deleteVideos($c);
                }
                
            $data['msg']="NO Videos To Display";
            $data['videos']=$this->Videos_details->getAllVideos();
            $this->load->view('CMS/testimonial_videos/videos_view',$data);
            
            }else{
            $data['msg']="NO Videos To Delete";
            $data['videos']=$this->Videos_details->getAllVideos($config["per_page"], $page);
            $this->load->view('CMS/testimonial_videos/videos_delete',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }

    function videos_view()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            
            $config = array();
 
            $config["base_url"] = base_url()."CMS/testimonial_videos/videos_view";

            $config["total_rows"] = $this->Videos_details->videos_count();
            //print_r($config["total_rows"]);
            //exit;
            $config["per_page"] = 10;
 
            $config["uri_segment"] = 4;
 
            $this->pagination->initialize($config);
 
            $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
 
            $data['videos']=$this->Videos_details->getAllVideos($config["per_page"], $page);

            $data['msg']="NO Videos To Display";
            //$data['videos']=$this->Videos_details->getAllVideos();
            $data["links"] = $this->pagination->create_links();
            $this->load->view('CMS/testimonial_videos/videos_view',$data);
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }

    function section_add()
    {
        
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];



            if(isset($_POST['submit']))
            {
                     
                    $section_name=addslashes($_POST['section_name']);

                        
                       
                        $data1=array('section_name'=>$section_name);
                         // print_r($data);
                         // die;
                        $add=$this->Videos_details->addsection($data1);
                        
                        if($add)
                        {   
                            $data['msg']="Section added";
                            $data['videos']=$this->Videos_details->getallsections();
                            $this->load->view('CMS/videosection/section_view',$data);
                        }
                        else
                        {
                            $this->load->view('CMS/videosection/section_add',$data);
                        }
            }
            else
            {
            $this->load->view('CMS/videosection/section_add',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
        
    
    }

     function section_view()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            
            $data['msg']="NO Video Sections To Display";
            $data['videos']=$this->Videos_details->getallsections();
            $this->load->view('CMS/videosection/section_view',$data);
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }

    function section_delete()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            if(isset($_POST['videosToDelete']))
            {
                foreach($_POST['videosToDelete'] as $c)
                {
                    $this->Videos_details->deletesection($c);
                }
                
            $data['msg']="NO Video Section To Display";
            $data['videos']=$this->Videos_details->getallsections();
            $this->load->view('CMS/videosection/section_view',$data);
            
            }else{
            $data['msg']="NO Videos To Delete";
            $data['videos']=$this->Videos_details->getallsections();
            $this->load->view('CMS/videosection/section_delete',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }
    
    function section_Update()
    {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            if(isset($_POST['category_name']))
            {
                
                $id=$_POST['categoryDDL'];
                $name=$_POST['category_name'];
                



                $data=array('section_name'=>$name);
                // print_r($data);
                // die;
                $add=$this->Videos_details->updatesection($id,$data);
                if($add)
                {   
                    $data['msg']="Section Name Updated";
                    $data['videos']=$this->Videos_details->getallsections();
                            $this->load->view('CMS/videosection/section_view',$data);
                }else
                {
                    $data['videos']=$this->Videos_details->getallsections();
                            $this->load->view('CMS/videosection/section_view',$data);
                }
            }
            else
            {
            $data['category']=$this->Videos_details->getallsections();
            $this->load->view('CMS/videosection/section_update',$data);
            }
        }
        else
        {
            //If no session, redirect to login page
            redirect('CMS/login', 'refresh');
        }
    }

    function section_details_json($id)
    {
        $size = count($this->Videos_details->getsectionbyid($id));
        $dataArr = $this->Videos_details->getsectionbyid($id);

        //echo $data;
        $data = array();
        for($i=0; $i<$size; $i++)
        {
            array_push($data,array_shift($dataArr));
        }
        
        header('Content-Type: application/json');
        echo json_encode($data);
        
    }

}
?>