<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/* 
 *  ======================================= 
 *  Author     : Muhammad Surya Ikhsanudin 
 *  License    : Protected 
 *  Email      : mutofiyah@gmail.com 
 *   
 *  Dilarang merubah, mengganti dan mendistribusikan 
 *  ulang tanpa sepengetahuan Author 
 *  ======================================= 
 */  
require_once APPPATH."/third_party/PHPExcel.php"; 
 
class Excel extends PHPExcel 
{ 
    public function __construct() 
    { 
        parent::__construct(); 
    } 

    function to_excel($array, $filename) 
    {
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename='.$filename.'.xls');

         //Filter all keys, they'll be table headers
        $h = array();

        foreach ($array as $row) 
        {
            foreach($row as $key=>$val)
            {
                if(!in_array($key, $h))
                {
                    $h[] = $key;   
                }
            }
        }
        //echo the entire table headers
        echo '<table><tr>';
        foreach($h as $key) 
        {
            $key = ucwords($key);
            echo '<th>'.$key.'</th>';
        }
        echo '</tr>';
        
        foreach($array as $row)
        {
             echo '<tr>';
            foreach($row as $val)
                 $this->writeRow($val);   
        }
        echo '</tr>';
        echo '</table>';
    }
    function writeRow($val) 
    {
        echo '<td>'.utf8_decode($val).'</td>';              
    }
}
